var objIdArray = ["tuner", "tsChange", "bandwidth", "standard", "profile", "plpId", "centerFrequency", "symbolRate"];
var ROW_NUM = 8;
var DVB_C = 1;
var DVB_T = 2;
var DVB_T2 = 3;
var QAM_B = 4;

window.onresize = function()
{
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
}

$(document).ready(function()
{
	var args = GetArgs();
	slotNo = parseInt(args["slotNo"], 10);
	portNo = parseInt(args["portNo"], 10);
	GetMainContentHeight(BUTTON_TOP_MENU, NO_BUTTON_CHANGE);
	funcUpdateDisplay();
});

function funcUpdateDisplay() 
{
	DisableButton("applyBtn");
	DisableButton("refreshBtn");
	PageLoadStatus(true);
	
	displayParam();
	
	ResetColor();
	EnableButton("refreshBtn");
	PageLoadStatus(false);
}

function displayParam() 
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();

	xmlHttp.open("GET", "/goform/formEMR30?type=" + PORT_CONFIG + "&cmd=" + GET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&ran=" + Math.random(), true);
	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = AjaxStrDeal(xmlHttp.responseText);
			if(response != "")
			{
				data = response.split(FIRST_DELIMITER);
				for(var i = 0; i < ROW_NUM; i++)
				{
					$("#" + objIdArray[i]).val(data[i]);
				}
				changeParam($("#standard"));
				refreshFlag = true;
			}
		}
	}
	xmlHttp.send(null);
}

function pageApply()
{
	var data;
	var response;
	var xmlHttp = GetHTTPObject();
	
	if(paramCheck() == false)
	{
		return;
	}
	
	data = "type=" + PORT_CONFIG + "&cmd=" + SET + "&language=" + language + "&slotNo=" + slotNo + "&portNo=" + portNo + "&setString=";
	data += generateData();
	
	xmlHttp.open("POST", "/goform/formEMR30", true)
	xmlHttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlHttp.setRequestHeader("Content-length", data.length);

	xmlHttp.onreadystatechange = function()
	{
		if((xmlHttp.readyState == 4) && (xmlHttp.status == 200))
		{
			response = parseInt(AjaxStrDeal(xmlHttp.responseText), 10);
			if(response == RETURN_OK)
			{
				applyFlag = true;
			}
			else
			{
				alert(returnError[language][response]);
			}
			GeneratePrompt(applyFlag, TOP, APPLY, language);  //设置后页面弹出提示
			applyFlag = false;  //设置标识符恢复为false
			funcUpdateDisplay();
		}
	}
	xmlHttp.send(data);
}

function generateData()
{
	var data;
	for(var i = 0; i < ROW_NUM; i++)
	{
		if(i == 0)
		{
			data = $("#" + objIdArray[i]).val();
		}
		else
		{
			data += FIRST_DELIMITER + $("#" + objIdArray[i]).val();
		}
	}
	return data;
}

function changeParam(obj)
{
	var curStandard = obj.val();
	if((curStandard == DVB_C) || (curStandard == QAM_B))
	{
		$("#profile").attr("disabled", true);
		$("#plpId").attr("disabled", true);
		$("#symbolRate").attr("disabled", false);
		if(curStandard == QAM_B)
		{
			$("#bandwidth").val(2);
		}
	}
	else if(curStandard == DVB_T)
	{
		$("#profile").attr("disabled", false);
		$("#plpId").attr("disabled", true);
		$("#symbolRate").attr("disabled", true);
	}
	else if(curStandard == DVB_T2)
	{
		$("#profile").attr("disabled", true);
		$("#plpId").attr("disabled", false);
		$("#symbolRate").attr("disabled", true);
	}
}

function paramCheck()
{
 	var returnFlag;
	
	if($("#standard").val() == DVB_T2)
	{
		returnFlag = ValidateParam($("#plpId"), "INT_DEC", 0, 255, "<PLP ID>", "<PLP ID>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}	
	returnFlag = ValidateParam($("#centerFrequency"), "INT_DEC", 42000, 870000, "<Center Frequency(KHz)>", "<中心频率(KHz)>", language);
	if(returnFlag == false)
	{
		return false;
	}
	if(($("#standard").val() == QAM_B) || ($("#standard").val() == DVB_C))
	{
		returnFlag = ValidateParam($("#symbolRate"), "INT_DEC", 1000, 7000, "<Symbol Rate(Ksps)>", "<符号率(Ksps)>", language);
		if(returnFlag == false)
		{
			return false;
		}
	}
	return true;
}